package io.k8s.api.core.v1


/** EventSource contains information for an event. */
final case class EventSource(
  component : Option[String] = None,
  host : Option[String] = None
) {

  /** Returns a new data with component set to new value */
  def withComponent(value: String) : EventSource = copy(component = Some(value))
  /** if component has a value, transforms to the result of function*/
  def mapComponent(f: String => String) : EventSource = copy(component = component.map(f))

  /** Returns a new data with host set to new value */
  def withHost(value: String) : EventSource = copy(host = Some(value))
  /** if host has a value, transforms to the result of function*/
  def mapHost(f: String => String) : EventSource = copy(host = host.map(f))
}

