package io.k8s.api.core.v1


/** FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. */
final case class FlexVolumeSource(
  driver : String,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  options : Option[Map[String, String]] = None
) {

  /** Returns a new data with driver set to new value */
  def withDriver(value: String) : FlexVolumeSource = copy(driver = value)
  /** transforms driver to result of function */
  def mapDriver(f: String => String) : FlexVolumeSource = copy(driver = f(driver))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : FlexVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : FlexVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : FlexVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : FlexVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : FlexVolumeSource = copy(secretRef = Some(value))
  /** if secretRef has a value, transforms to the result of function*/
  def mapSecretRef(f: io.k8s.api.core.v1.LocalObjectReference => io.k8s.api.core.v1.LocalObjectReference) : FlexVolumeSource = copy(secretRef = secretRef.map(f))

  /** Returns a new data with options set to new value */
  def withOptions(value: Map[String, String]) : FlexVolumeSource = copy(options = Some(value))
  /** Adds new values to options */
  def addOptions(newValues: (String, String)*) : FlexVolumeSource = copy(options = Some(options.fold(newValues.toMap)(_ ++ newValues)))
  /** if options has a value, transforms to the result of function*/
  def mapOptions(f: Map[String, String] => Map[String, String]) : FlexVolumeSource = copy(options = options.map(f))
}

