package io.k8s.api.core.v1


/** LimitRangeSpec defines a min/max usage limit for resources that match on kind. */
final case class LimitRangeSpec(
  limits : Seq[io.k8s.api.core.v1.LimitRangeItem]
) {

  /** Returns a new data with limits set to new value */
  def withLimits(value: Seq[io.k8s.api.core.v1.LimitRangeItem]) : LimitRangeSpec = copy(limits = value)
  /** Appends new values to limits */
  def addLimits(newValues: io.k8s.api.core.v1.LimitRangeItem*) : LimitRangeSpec = copy(limits = limits ++ newValues)
  /** transforms limits to result of function */
  def mapLimits(f: Seq[io.k8s.api.core.v1.LimitRangeItem] => Seq[io.k8s.api.core.v1.LimitRangeItem]) : LimitRangeSpec = copy(limits = f(limits))
}

