package io.k8s.api.core.v1


/** LoadBalancerStatus represents the status of a load-balancer. */
final case class LoadBalancerStatus(
  ingress : Option[Seq[io.k8s.api.core.v1.LoadBalancerIngress]] = None
) {

  /** Returns a new data with ingress set to new value */
  def withIngress(value: Seq[io.k8s.api.core.v1.LoadBalancerIngress]) : LoadBalancerStatus = copy(ingress = Some(value))
  /** Appends new values to ingress */
  def addIngress(newValues: io.k8s.api.core.v1.LoadBalancerIngress*) : LoadBalancerStatus = copy(ingress = Some(ingress.fold(newValues)(_ ++ newValues)))
  /** if ingress has a value, transforms to the result of function*/
  def mapIngress(f: Seq[io.k8s.api.core.v1.LoadBalancerIngress] => Seq[io.k8s.api.core.v1.LoadBalancerIngress]) : LoadBalancerStatus = copy(ingress = ingress.map(f))
}

