package io.k8s.api.core.v1


/** NamespaceSpec describes the attributes on a Namespace. */
final case class NamespaceSpec(
  finalizers : Option[Seq[String]] = None
) {

  /** Returns a new data with finalizers set to new value */
  def withFinalizers(value: Seq[String]) : NamespaceSpec = copy(finalizers = Some(value))
  /** Appends new values to finalizers */
  def addFinalizers(newValues: String*) : NamespaceSpec = copy(finalizers = Some(finalizers.fold(newValues)(_ ++ newValues)))
  /** if finalizers has a value, transforms to the result of function*/
  def mapFinalizers(f: Seq[String] => Seq[String]) : NamespaceSpec = copy(finalizers = finalizers.map(f))
}

