package io.k8s.api.core.v1


/** NodeAddress contains information for the node's address. */
final case class NodeAddress(
  address : String,
  `type` : String
) {

  /** Returns a new data with address set to new value */
  def withAddress(value: String) : NodeAddress = copy(address = value)
  /** transforms address to result of function */
  def mapAddress(f: String => String) : NodeAddress = copy(address = f(address))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : NodeAddress = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : NodeAddress = copy(`type` = f(`type`))
}

