package io.k8s.api.core.v1


/** NodeCondition contains condition information for a node. */
final case class NodeCondition(
  status : String,
  `type` : String,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  lastHeartbeatTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : NodeCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : NodeCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : NodeCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : NodeCondition = copy(`type` = f(`type`))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : NodeCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : NodeCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : NodeCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : NodeCondition = copy(message = message.map(f))

  /** Returns a new data with lastHeartbeatTime set to new value */
  def withLastHeartbeatTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastHeartbeatTime = Some(value))
  /** if lastHeartbeatTime has a value, transforms to the result of function*/
  def mapLastHeartbeatTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NodeCondition = copy(lastHeartbeatTime = lastHeartbeatTime.map(f))
}

