package io.k8s.api.core.v1


/** A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm. */
final case class NodeSelectorTerm(
  matchExpressions : Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None,
  matchFields : Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None
) {

  /** Returns a new data with matchExpressions set to new value */
  def withMatchExpressions(value: Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchExpressions = Some(value))
  /** Appends new values to matchExpressions */
  def addMatchExpressions(newValues: io.k8s.api.core.v1.NodeSelectorRequirement*) : NodeSelectorTerm = copy(matchExpressions = Some(matchExpressions.fold(newValues)(_ ++ newValues)))
  /** if matchExpressions has a value, transforms to the result of function*/
  def mapMatchExpressions(f: Seq[io.k8s.api.core.v1.NodeSelectorRequirement] => Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchExpressions = matchExpressions.map(f))

  /** Returns a new data with matchFields set to new value */
  def withMatchFields(value: Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchFields = Some(value))
  /** Appends new values to matchFields */
  def addMatchFields(newValues: io.k8s.api.core.v1.NodeSelectorRequirement*) : NodeSelectorTerm = copy(matchFields = Some(matchFields.fold(newValues)(_ ++ newValues)))
  /** if matchFields has a value, transforms to the result of function*/
  def mapMatchFields(f: Seq[io.k8s.api.core.v1.NodeSelectorRequirement] => Seq[io.k8s.api.core.v1.NodeSelectorRequirement]) : NodeSelectorTerm = copy(matchFields = matchFields.map(f))
}

