package io.k8s.api.core.v1


/** ObjectFieldSelector selects an APIVersioned field of an object. */
final case class ObjectFieldSelector(
  fieldPath : String
) {

  /** Returns a new data with fieldPath set to new value */
  def withFieldPath(value: String) : ObjectFieldSelector = copy(fieldPath = value)
  /** transforms fieldPath to result of function */
  def mapFieldPath(f: String => String) : ObjectFieldSelector = copy(fieldPath = f(fieldPath))
}

