package io.k8s.api.core.v1


/** ObjectReference contains enough information to let you inspect or modify the referred object. */
final case class ObjectReference(
  fieldPath : Option[String] = None,
  name : Option[String] = None,
  resourceVersion : Option[String] = None,
  uid : Option[String] = None,
  namespace : Option[String] = None
) {

  /** Returns a new data with fieldPath set to new value */
  def withFieldPath(value: String) : ObjectReference = copy(fieldPath = Some(value))
  /** if fieldPath has a value, transforms to the result of function*/
  def mapFieldPath(f: String => String) : ObjectReference = copy(fieldPath = fieldPath.map(f))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ObjectReference = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ObjectReference = copy(name = name.map(f))

  /** Returns a new data with resourceVersion set to new value */
  def withResourceVersion(value: String) : ObjectReference = copy(resourceVersion = Some(value))
  /** if resourceVersion has a value, transforms to the result of function*/
  def mapResourceVersion(f: String => String) : ObjectReference = copy(resourceVersion = resourceVersion.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : ObjectReference = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : ObjectReference = copy(uid = uid.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ObjectReference = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : ObjectReference = copy(namespace = namespace.map(f))
}

