package io.k8s.api.core.v1


/** PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource. */
final case class PersistentVolumeClaimTemplate(
  spec : io.k8s.api.core.v1.PersistentVolumeClaimSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) {

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaimTemplate = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.core.v1.PersistentVolumeClaimSpec => io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaimTemplate = copy(spec = f(spec))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaimTemplate = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaimTemplate = copy(metadata = metadata.map(f))
}

