package io.k8s.api.core.v1


/** IP address information for entries in the (plural) PodIPs field. Each entry includes:

	IP: An IP address allocated to the pod. Routable at least within the cluster. */
final case class PodIP(
  ip : Option[String] = None
) {

  /** Returns a new data with ip set to new value */
  def withIp(value: String) : PodIP = copy(ip = Some(value))
  /** if ip has a value, transforms to the result of function*/
  def mapIp(f: String => String) : PodIP = copy(ip = ip.map(f))
}

