package io.k8s.api.core.v1


/** PodTemplateSpec describes the data a pod should have when created from a template */
final case class PodTemplateSpec(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.core.v1.PodSpec] = None
) {

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodTemplateSpec = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodTemplateSpec = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.PodSpec) : PodTemplateSpec = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.PodSpec => io.k8s.api.core.v1.PodSpec) : PodTemplateSpec = copy(spec = spec.map(f))
}

