package io.k8s.api.core.v1


/** PortworxVolumeSource represents a Portworx volume resource. */
final case class PortworxVolumeSource(
  volumeID : String,
  fsType : Option[String] = None,
  readOnly : Option[Boolean] = None
) {

  /** Returns a new data with volumeID set to new value */
  def withVolumeID(value: String) : PortworxVolumeSource = copy(volumeID = value)
  /** transforms volumeID to result of function */
  def mapVolumeID(f: String => String) : PortworxVolumeSource = copy(volumeID = f(volumeID))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : PortworxVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : PortworxVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : PortworxVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : PortworxVolumeSource = copy(readOnly = readOnly.map(f))
}

