package io.k8s.api.core.v1


/** An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op). */
final case class PreferredSchedulingTerm(
  preference : io.k8s.api.core.v1.NodeSelectorTerm,
  weight : Int
) {

  /** Returns a new data with preference set to new value */
  def withPreference(value: io.k8s.api.core.v1.NodeSelectorTerm) : PreferredSchedulingTerm = copy(preference = value)
  /** transforms preference to result of function */
  def mapPreference(f: io.k8s.api.core.v1.NodeSelectorTerm => io.k8s.api.core.v1.NodeSelectorTerm) : PreferredSchedulingTerm = copy(preference = f(preference))

  /** Returns a new data with weight set to new value */
  def withWeight(value: Int) : PreferredSchedulingTerm = copy(weight = value)
  /** transforms weight to result of function */
  def mapWeight(f: Int => Int) : PreferredSchedulingTerm = copy(weight = f(weight))
}

