package io.k8s.api.core.v1


/** ResourceRequirements describes the compute resource requirements. */
final case class ResourceRequirements(
  limits : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  requests : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {

  /** Returns a new data with limits set to new value */
  def withLimits(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceRequirements = copy(limits = Some(value))
  /** Adds new values to limits */
  def addLimits(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : ResourceRequirements = copy(limits = Some(limits.fold(newValues.toMap)(_ ++ newValues)))
  /** if limits has a value, transforms to the result of function*/
  def mapLimits(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceRequirements = copy(limits = limits.map(f))

  /** Returns a new data with requests set to new value */
  def withRequests(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceRequirements = copy(requests = Some(value))
  /** Adds new values to requests */
  def addRequests(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : ResourceRequirements = copy(requests = Some(requests.fold(newValues.toMap)(_ ++ newValues)))
  /** if requests has a value, transforms to the result of function*/
  def mapRequests(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : ResourceRequirements = copy(requests = requests.map(f))
}

