package io.k8s.api.core.v1


/** SELinuxOptions are the labels to be applied to the container */
final case class SELinuxOptions(
  level : Option[String] = None,
  role : Option[String] = None,
  `type` : Option[String] = None,
  user : Option[String] = None
) {

  /** Returns a new data with level set to new value */
  def withLevel(value: String) : SELinuxOptions = copy(level = Some(value))
  /** if level has a value, transforms to the result of function*/
  def mapLevel(f: String => String) : SELinuxOptions = copy(level = level.map(f))

  /** Returns a new data with role set to new value */
  def withRole(value: String) : SELinuxOptions = copy(role = Some(value))
  /** if role has a value, transforms to the result of function*/
  def mapRole(f: String => String) : SELinuxOptions = copy(role = role.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : SELinuxOptions = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : SELinuxOptions = copy(`type` = `type`.map(f))

  /** Returns a new data with user set to new value */
  def withUser(value: String) : SELinuxOptions = copy(user = Some(value))
  /** if user has a value, transforms to the result of function*/
  def mapUser(f: String => String) : SELinuxOptions = copy(user = user.map(f))
}

