package io.k8s.api.core.v1


/** ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume */
final case class ScaleIOPersistentVolumeSource(
  system : String,
  secretRef : io.k8s.api.core.v1.SecretReference,
  gateway : String,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  storagePool : Option[String] = None,
  protectionDomain : Option[String] = None,
  volumeName : Option[String] = None,
  sslEnabled : Option[Boolean] = None,
  storageMode : Option[String] = None
) {

  /** Returns a new data with system set to new value */
  def withSystem(value: String) : ScaleIOPersistentVolumeSource = copy(system = value)
  /** transforms system to result of function */
  def mapSystem(f: String => String) : ScaleIOPersistentVolumeSource = copy(system = f(system))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.SecretReference) : ScaleIOPersistentVolumeSource = copy(secretRef = value)
  /** transforms secretRef to result of function */
  def mapSecretRef(f: io.k8s.api.core.v1.SecretReference => io.k8s.api.core.v1.SecretReference) : ScaleIOPersistentVolumeSource = copy(secretRef = f(secretRef))

  /** Returns a new data with gateway set to new value */
  def withGateway(value: String) : ScaleIOPersistentVolumeSource = copy(gateway = value)
  /** transforms gateway to result of function */
  def mapGateway(f: String => String) : ScaleIOPersistentVolumeSource = copy(gateway = f(gateway))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : ScaleIOPersistentVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : ScaleIOPersistentVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : ScaleIOPersistentVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : ScaleIOPersistentVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with storagePool set to new value */
  def withStoragePool(value: String) : ScaleIOPersistentVolumeSource = copy(storagePool = Some(value))
  /** if storagePool has a value, transforms to the result of function*/
  def mapStoragePool(f: String => String) : ScaleIOPersistentVolumeSource = copy(storagePool = storagePool.map(f))

  /** Returns a new data with protectionDomain set to new value */
  def withProtectionDomain(value: String) : ScaleIOPersistentVolumeSource = copy(protectionDomain = Some(value))
  /** if protectionDomain has a value, transforms to the result of function*/
  def mapProtectionDomain(f: String => String) : ScaleIOPersistentVolumeSource = copy(protectionDomain = protectionDomain.map(f))

  /** Returns a new data with volumeName set to new value */
  def withVolumeName(value: String) : ScaleIOPersistentVolumeSource = copy(volumeName = Some(value))
  /** if volumeName has a value, transforms to the result of function*/
  def mapVolumeName(f: String => String) : ScaleIOPersistentVolumeSource = copy(volumeName = volumeName.map(f))

  /** Returns a new data with sslEnabled set to new value */
  def withSslEnabled(value: Boolean) : ScaleIOPersistentVolumeSource = copy(sslEnabled = Some(value))
  /** if sslEnabled has a value, transforms to the result of function*/
  def mapSslEnabled(f: Boolean => Boolean) : ScaleIOPersistentVolumeSource = copy(sslEnabled = sslEnabled.map(f))

  /** Returns a new data with storageMode set to new value */
  def withStorageMode(value: String) : ScaleIOPersistentVolumeSource = copy(storageMode = Some(value))
  /** if storageMode has a value, transforms to the result of function*/
  def mapStorageMode(f: String => String) : ScaleIOPersistentVolumeSource = copy(storageMode = storageMode.map(f))
}

