package io.k8s.api.core.v1


/** SecretKeySelector selects a key of a Secret. */
final case class SecretKeySelector(
  key : String,
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {

  /** Returns a new data with key set to new value */
  def withKey(value: String) : SecretKeySelector = copy(key = value)
  /** transforms key to result of function */
  def mapKey(f: String => String) : SecretKeySelector = copy(key = f(key))

  /** Returns a new data with name set to new value */
  def withName(value: String) : SecretKeySelector = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : SecretKeySelector = copy(name = name.map(f))

  /** Returns a new data with optional set to new value */
  def withOptional(value: Boolean) : SecretKeySelector = copy(optional = Some(value))
  /** if optional has a value, transforms to the result of function*/
  def mapOptional(f: Boolean => Boolean) : SecretKeySelector = copy(optional = optional.map(f))
}

