package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** SecretList is a list of Secret. */
final case class SecretList(
  items : Seq[io.k8s.api.core.v1.Secret],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "SecretList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.Secret]) : SecretList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.Secret*) : SecretList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.Secret] => Seq[io.k8s.api.core.v1.Secret]) : SecretList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : SecretList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : SecretList = copy(metadata = metadata.map(f))
}

