package io.k8s.api.core.v1


/** Adapts a secret into a projected volume.

The contents of the target Secret's Data field will be presented in a projected volume as files using the keys in the Data field as the file names. Note that this is identical to a secret volume source without the default mode. */
final case class SecretProjection(
  items : Option[Seq[io.k8s.api.core.v1.KeyToPath]] = None,
  name : Option[String] = None,
  optional : Option[Boolean] = None
) {

  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.KeyToPath]) : SecretProjection = copy(items = Some(value))
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.KeyToPath*) : SecretProjection = copy(items = Some(items.fold(newValues)(_ ++ newValues)))
  /** if items has a value, transforms to the result of function*/
  def mapItems(f: Seq[io.k8s.api.core.v1.KeyToPath] => Seq[io.k8s.api.core.v1.KeyToPath]) : SecretProjection = copy(items = items.map(f))

  /** Returns a new data with name set to new value */
  def withName(value: String) : SecretProjection = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : SecretProjection = copy(name = name.map(f))

  /** Returns a new data with optional set to new value */
  def withOptional(value: Boolean) : SecretProjection = copy(optional = Some(value))
  /** if optional has a value, transforms to the result of function*/
  def mapOptional(f: Boolean => Boolean) : SecretProjection = copy(optional = optional.map(f))
}

