package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ServiceList holds a list of services. */
final case class ServiceList(
  items : Seq[io.k8s.api.core.v1.Service],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ServiceList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.Service]) : ServiceList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.Service*) : ServiceList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.Service] => Seq[io.k8s.api.core.v1.Service]) : ServiceList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ServiceList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ServiceList = copy(metadata = metadata.map(f))
}

