package io.k8s.api.core.v1


/** Represents a StorageOS persistent volume resource. */
final case class StorageOSPersistentVolumeSource(
  volumeNamespace : Option[String] = None,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.ObjectReference] = None,
  volumeName : Option[String] = None
) {

  /** Returns a new data with volumeNamespace set to new value */
  def withVolumeNamespace(value: String) : StorageOSPersistentVolumeSource = copy(volumeNamespace = Some(value))
  /** if volumeNamespace has a value, transforms to the result of function*/
  def mapVolumeNamespace(f: String => String) : StorageOSPersistentVolumeSource = copy(volumeNamespace = volumeNamespace.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : StorageOSPersistentVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : StorageOSPersistentVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : StorageOSPersistentVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : StorageOSPersistentVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.ObjectReference) : StorageOSPersistentVolumeSource = copy(secretRef = Some(value))
  /** if secretRef has a value, transforms to the result of function*/
  def mapSecretRef(f: io.k8s.api.core.v1.ObjectReference => io.k8s.api.core.v1.ObjectReference) : StorageOSPersistentVolumeSource = copy(secretRef = secretRef.map(f))

  /** Returns a new data with volumeName set to new value */
  def withVolumeName(value: String) : StorageOSPersistentVolumeSource = copy(volumeName = Some(value))
  /** if volumeName has a value, transforms to the result of function*/
  def mapVolumeName(f: String => String) : StorageOSPersistentVolumeSource = copy(volumeName = volumeName.map(f))
}

