package io.k8s.api.core.v1


/** Represents a StorageOS persistent volume resource. */
final case class StorageOSVolumeSource(
  volumeNamespace : Option[String] = None,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  volumeName : Option[String] = None
) {

  /** Returns a new data with volumeNamespace set to new value */
  def withVolumeNamespace(value: String) : StorageOSVolumeSource = copy(volumeNamespace = Some(value))
  /** if volumeNamespace has a value, transforms to the result of function*/
  def mapVolumeNamespace(f: String => String) : StorageOSVolumeSource = copy(volumeNamespace = volumeNamespace.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : StorageOSVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : StorageOSVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : StorageOSVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : StorageOSVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : StorageOSVolumeSource = copy(secretRef = Some(value))
  /** if secretRef has a value, transforms to the result of function*/
  def mapSecretRef(f: io.k8s.api.core.v1.LocalObjectReference => io.k8s.api.core.v1.LocalObjectReference) : StorageOSVolumeSource = copy(secretRef = secretRef.map(f))

  /** Returns a new data with volumeName set to new value */
  def withVolumeName(value: String) : StorageOSVolumeSource = copy(volumeName = Some(value))
  /** if volumeName has a value, transforms to the result of function*/
  def mapVolumeName(f: String => String) : StorageOSVolumeSource = copy(volumeName = volumeName.map(f))
}

