package io.k8s.api.core.v1


/** Sysctl defines a kernel parameter to be set */
final case class Sysctl(
  name : String,
  value : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : Sysctl = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : Sysctl = copy(name = f(name))

  /** Returns a new data with value set to new value */
  def withValue(value: String) : Sysctl = copy(value = value)
  /** transforms value to result of function */
  def mapValue(f: String => String) : Sysctl = copy(value = f(value))
}

