package io.k8s.api.core.v1


/** WindowsSecurityContextOptions contain Windows-specific options and credentials. */
final case class WindowsSecurityContextOptions(
  gmsaCredentialSpec : Option[String] = None,
  gmsaCredentialSpecName : Option[String] = None,
  hostProcess : Option[Boolean] = None,
  runAsUserName : Option[String] = None
) {

  /** Returns a new data with gmsaCredentialSpec set to new value */
  def withGmsaCredentialSpec(value: String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpec = Some(value))
  /** if gmsaCredentialSpec has a value, transforms to the result of function*/
  def mapGmsaCredentialSpec(f: String => String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpec = gmsaCredentialSpec.map(f))

  /** Returns a new data with gmsaCredentialSpecName set to new value */
  def withGmsaCredentialSpecName(value: String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpecName = Some(value))
  /** if gmsaCredentialSpecName has a value, transforms to the result of function*/
  def mapGmsaCredentialSpecName(f: String => String) : WindowsSecurityContextOptions = copy(gmsaCredentialSpecName = gmsaCredentialSpecName.map(f))

  /** Returns a new data with hostProcess set to new value */
  def withHostProcess(value: Boolean) : WindowsSecurityContextOptions = copy(hostProcess = Some(value))
  /** if hostProcess has a value, transforms to the result of function*/
  def mapHostProcess(f: Boolean => Boolean) : WindowsSecurityContextOptions = copy(hostProcess = hostProcess.map(f))

  /** Returns a new data with runAsUserName set to new value */
  def withRunAsUserName(value: String) : WindowsSecurityContextOptions = copy(runAsUserName = Some(value))
  /** if runAsUserName has a value, transforms to the result of function*/
  def mapRunAsUserName(f: String => String) : WindowsSecurityContextOptions = copy(runAsUserName = runAsUserName.map(f))
}

