package io.k8s.api.discovery.v1


/** EndpointConditions represents the current condition of an endpoint. */
final case class EndpointConditions(
  ready : Option[Boolean] = None,
  serving : Option[Boolean] = None,
  terminating : Option[Boolean] = None
) {

  /** Returns a new data with ready set to new value */
  def withReady(value: Boolean) : EndpointConditions = copy(ready = Some(value))
  /** if ready has a value, transforms to the result of function*/
  def mapReady(f: Boolean => Boolean) : EndpointConditions = copy(ready = ready.map(f))

  /** Returns a new data with serving set to new value */
  def withServing(value: Boolean) : EndpointConditions = copy(serving = Some(value))
  /** if serving has a value, transforms to the result of function*/
  def mapServing(f: Boolean => Boolean) : EndpointConditions = copy(serving = serving.map(f))

  /** Returns a new data with terminating set to new value */
  def withTerminating(value: Boolean) : EndpointConditions = copy(terminating = Some(value))
  /** if terminating has a value, transforms to the result of function*/
  def mapTerminating(f: Boolean => Boolean) : EndpointConditions = copy(terminating = terminating.map(f))
}

