package io.k8s.api.flowcontrol.v1beta1


/** FlowSchemaSpec describes how the FlowSchema's specification looks like. */
final case class FlowSchemaSpec(
  priorityLevelConfiguration : io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference,
  distinguisherMethod : Option[io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod] = None,
  matchingPrecedence : Option[Int] = None,
  rules : Option[Seq[io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects]] = None
) {

  /** Returns a new data with priorityLevelConfiguration set to new value */
  def withPriorityLevelConfiguration(value: io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference) : FlowSchemaSpec = copy(priorityLevelConfiguration = value)
  /** transforms priorityLevelConfiguration to result of function */
  def mapPriorityLevelConfiguration(f: io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference => io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationReference) : FlowSchemaSpec = copy(priorityLevelConfiguration = f(priorityLevelConfiguration))

  /** Returns a new data with distinguisherMethod set to new value */
  def withDistinguisherMethod(value: io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod) : FlowSchemaSpec = copy(distinguisherMethod = Some(value))
  /** if distinguisherMethod has a value, transforms to the result of function*/
  def mapDistinguisherMethod(f: io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod => io.k8s.api.flowcontrol.v1beta1.FlowDistinguisherMethod) : FlowSchemaSpec = copy(distinguisherMethod = distinguisherMethod.map(f))

  /** Returns a new data with matchingPrecedence set to new value */
  def withMatchingPrecedence(value: Int) : FlowSchemaSpec = copy(matchingPrecedence = Some(value))
  /** if matchingPrecedence has a value, transforms to the result of function*/
  def mapMatchingPrecedence(f: Int => Int) : FlowSchemaSpec = copy(matchingPrecedence = matchingPrecedence.map(f))

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects]) : FlowSchemaSpec = copy(rules = Some(value))
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects*) : FlowSchemaSpec = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))
  /** if rules has a value, transforms to the result of function*/
  def mapRules(f: Seq[io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects] => Seq[io.k8s.api.flowcontrol.v1beta1.PolicyRulesWithSubjects]) : FlowSchemaSpec = copy(rules = rules.map(f))
}

