package io.k8s.api.flowcontrol.v1beta1


/** NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request. */
final case class NonResourcePolicyRule(
  nonResourceURLs : Seq[String],
  verbs : Seq[String]
) {

  /** Returns a new data with nonResourceURLs set to new value */
  def withNonResourceURLs(value: Seq[String]) : NonResourcePolicyRule = copy(nonResourceURLs = value)
  /** Appends new values to nonResourceURLs */
  def addNonResourceURLs(newValues: String*) : NonResourcePolicyRule = copy(nonResourceURLs = nonResourceURLs ++ newValues)
  /** transforms nonResourceURLs to result of function */
  def mapNonResourceURLs(f: Seq[String] => Seq[String]) : NonResourcePolicyRule = copy(nonResourceURLs = f(nonResourceURLs))

  /** Returns a new data with verbs set to new value */
  def withVerbs(value: Seq[String]) : NonResourcePolicyRule = copy(verbs = value)
  /** Appends new values to verbs */
  def addVerbs(newValues: String*) : NonResourcePolicyRule = copy(verbs = verbs ++ newValues)
  /** transforms verbs to result of function */
  def mapVerbs(f: Seq[String] => Seq[String]) : NonResourcePolicyRule = copy(verbs = f(verbs))
}

