package io.k8s.api.flowcontrol.v1beta1


/** UserSubject holds detailed information for user-kind subject. */
final case class UserSubject(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : UserSubject = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : UserSubject = copy(name = f(name))
}

