package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s._

/** PriorityLevelConfigurationList is a list of PriorityLevelConfiguration objects. */
final case class PriorityLevelConfigurationList(
  items : Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "PriorityLevelConfigurationList", "v1beta2")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration]) : PriorityLevelConfigurationList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration*) : PriorityLevelConfigurationList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration] => Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration]) : PriorityLevelConfigurationList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PriorityLevelConfigurationList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PriorityLevelConfigurationList = copy(metadata = metadata.map(f))
}

