package io.k8s.api.flowcontrol.v1beta2


/** PriorityLevelConfigurationSpec specifies the configuration of a priority level. */
final case class PriorityLevelConfigurationSpec(
  `type` : String,
  limited : Option[io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : PriorityLevelConfigurationSpec = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : PriorityLevelConfigurationSpec = copy(`type` = f(`type`))

  /** Returns a new data with limited set to new value */
  def withLimited(value: io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration) : PriorityLevelConfigurationSpec = copy(limited = Some(value))
  /** if limited has a value, transforms to the result of function*/
  def mapLimited(f: io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration => io.k8s.api.flowcontrol.v1beta2.LimitedPriorityLevelConfiguration) : PriorityLevelConfigurationSpec = copy(limited = limited.map(f))
}

