package io.k8s.api.flowcontrol.v1beta2


/** QueuingConfiguration holds the configuration parameters for queuing */
final case class QueuingConfiguration(
  handSize : Option[Int] = None,
  queueLengthLimit : Option[Int] = None,
  queues : Option[Int] = None
) {

  /** Returns a new data with handSize set to new value */
  def withHandSize(value: Int) : QueuingConfiguration = copy(handSize = Some(value))
  /** if handSize has a value, transforms to the result of function*/
  def mapHandSize(f: Int => Int) : QueuingConfiguration = copy(handSize = handSize.map(f))

  /** Returns a new data with queueLengthLimit set to new value */
  def withQueueLengthLimit(value: Int) : QueuingConfiguration = copy(queueLengthLimit = Some(value))
  /** if queueLengthLimit has a value, transforms to the result of function*/
  def mapQueueLengthLimit(f: Int => Int) : QueuingConfiguration = copy(queueLengthLimit = queueLengthLimit.map(f))

  /** Returns a new data with queues set to new value */
  def withQueues(value: Int) : QueuingConfiguration = copy(queues = Some(value))
  /** if queues has a value, transforms to the result of function*/
  def mapQueues(f: Int => Int) : QueuingConfiguration = copy(queues = queues.map(f))
}

