package io.k8s.api.networking.v1


/** HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'. */
final case class HTTPIngressRuleValue(
  paths : Seq[io.k8s.api.networking.v1.HTTPIngressPath]
) {

  /** Returns a new data with paths set to new value */
  def withPaths(value: Seq[io.k8s.api.networking.v1.HTTPIngressPath]) : HTTPIngressRuleValue = copy(paths = value)
  /** Appends new values to paths */
  def addPaths(newValues: io.k8s.api.networking.v1.HTTPIngressPath*) : HTTPIngressRuleValue = copy(paths = paths ++ newValues)
  /** transforms paths to result of function */
  def mapPaths(f: Seq[io.k8s.api.networking.v1.HTTPIngressPath] => Seq[io.k8s.api.networking.v1.HTTPIngressPath]) : HTTPIngressRuleValue = copy(paths = f(paths))
}

