package io.k8s.api.networking.v1


/** IngressBackend describes all endpoints for a given service and port. */
final case class IngressBackend(
  resource : Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  service : Option[io.k8s.api.networking.v1.IngressServiceBackend] = None
) {

  /** Returns a new data with resource set to new value */
  def withResource(value: io.k8s.api.core.v1.TypedLocalObjectReference) : IngressBackend = copy(resource = Some(value))
  /** if resource has a value, transforms to the result of function*/
  def mapResource(f: io.k8s.api.core.v1.TypedLocalObjectReference => io.k8s.api.core.v1.TypedLocalObjectReference) : IngressBackend = copy(resource = resource.map(f))

  /** Returns a new data with service set to new value */
  def withService(value: io.k8s.api.networking.v1.IngressServiceBackend) : IngressBackend = copy(service = Some(value))
  /** if service has a value, transforms to the result of function*/
  def mapService(f: io.k8s.api.networking.v1.IngressServiceBackend => io.k8s.api.networking.v1.IngressServiceBackend) : IngressBackend = copy(service = service.map(f))
}

