package io.k8s.api.networking.v1


/** IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue. */
final case class IngressRule(
  host : Option[String] = None,
  http : Option[io.k8s.api.networking.v1.HTTPIngressRuleValue] = None
) {

  /** Returns a new data with host set to new value */
  def withHost(value: String) : IngressRule = copy(host = Some(value))
  /** if host has a value, transforms to the result of function*/
  def mapHost(f: String => String) : IngressRule = copy(host = host.map(f))

  /** Returns a new data with http set to new value */
  def withHttp(value: io.k8s.api.networking.v1.HTTPIngressRuleValue) : IngressRule = copy(http = Some(value))
  /** if http has a value, transforms to the result of function*/
  def mapHttp(f: io.k8s.api.networking.v1.HTTPIngressRuleValue => io.k8s.api.networking.v1.HTTPIngressRuleValue) : IngressRule = copy(http = http.map(f))
}

