package io.k8s.api.networking.v1


/** IngressSpec describes the Ingress the user wishes to exist. */
final case class IngressSpec(
  defaultBackend : Option[io.k8s.api.networking.v1.IngressBackend] = None,
  ingressClassName : Option[String] = None,
  rules : Option[Seq[io.k8s.api.networking.v1.IngressRule]] = None,
  tls : Option[Seq[io.k8s.api.networking.v1.IngressTLS]] = None
) {

  /** Returns a new data with defaultBackend set to new value */
  def withDefaultBackend(value: io.k8s.api.networking.v1.IngressBackend) : IngressSpec = copy(defaultBackend = Some(value))
  /** if defaultBackend has a value, transforms to the result of function*/
  def mapDefaultBackend(f: io.k8s.api.networking.v1.IngressBackend => io.k8s.api.networking.v1.IngressBackend) : IngressSpec = copy(defaultBackend = defaultBackend.map(f))

  /** Returns a new data with ingressClassName set to new value */
  def withIngressClassName(value: String) : IngressSpec = copy(ingressClassName = Some(value))
  /** if ingressClassName has a value, transforms to the result of function*/
  def mapIngressClassName(f: String => String) : IngressSpec = copy(ingressClassName = ingressClassName.map(f))

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.networking.v1.IngressRule]) : IngressSpec = copy(rules = Some(value))
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.networking.v1.IngressRule*) : IngressSpec = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))
  /** if rules has a value, transforms to the result of function*/
  def mapRules(f: Seq[io.k8s.api.networking.v1.IngressRule] => Seq[io.k8s.api.networking.v1.IngressRule]) : IngressSpec = copy(rules = rules.map(f))

  /** Returns a new data with tls set to new value */
  def withTls(value: Seq[io.k8s.api.networking.v1.IngressTLS]) : IngressSpec = copy(tls = Some(value))
  /** Appends new values to tls */
  def addTls(newValues: io.k8s.api.networking.v1.IngressTLS*) : IngressSpec = copy(tls = Some(tls.fold(newValues)(_ ++ newValues)))
  /** if tls has a value, transforms to the result of function*/
  def mapTls(f: Seq[io.k8s.api.networking.v1.IngressTLS] => Seq[io.k8s.api.networking.v1.IngressTLS]) : IngressSpec = copy(tls = tls.map(f))
}

