package io.k8s.api.networking.v1


/** NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8 */
final case class NetworkPolicyEgressRule(
  ports : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPort]] = None,
  to : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]] = None
) {

  /** Returns a new data with ports set to new value */
  def withPorts(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPort]) : NetworkPolicyEgressRule = copy(ports = Some(value))
  /** Appends new values to ports */
  def addPorts(newValues: io.k8s.api.networking.v1.NetworkPolicyPort*) : NetworkPolicyEgressRule = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))
  /** if ports has a value, transforms to the result of function*/
  def mapPorts(f: Seq[io.k8s.api.networking.v1.NetworkPolicyPort] => Seq[io.k8s.api.networking.v1.NetworkPolicyPort]) : NetworkPolicyEgressRule = copy(ports = ports.map(f))

  /** Returns a new data with to set to new value */
  def withTo(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]) : NetworkPolicyEgressRule = copy(to = Some(value))
  /** Appends new values to to */
  def addTo(newValues: io.k8s.api.networking.v1.NetworkPolicyPeer*) : NetworkPolicyEgressRule = copy(to = Some(to.fold(newValues)(_ ++ newValues)))
  /** if to has a value, transforms to the result of function*/
  def mapTo(f: Seq[io.k8s.api.networking.v1.NetworkPolicyPeer] => Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]) : NetworkPolicyEgressRule = copy(to = to.map(f))
}

