package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** RoleBinding references a role, but does not contain it.  It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace. */
final case class RoleBinding(
  roleRef : io.k8s.api.rbac.v1.RoleRef,
  subjects : Option[Seq[io.k8s.api.rbac.v1.Subject]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "RoleBinding", "v1")


  /** Returns a new data with roleRef set to new value */
  def withRoleRef(value: io.k8s.api.rbac.v1.RoleRef) : RoleBinding = copy(roleRef = value)
  /** transforms roleRef to result of function */
  def mapRoleRef(f: io.k8s.api.rbac.v1.RoleRef => io.k8s.api.rbac.v1.RoleRef) : RoleBinding = copy(roleRef = f(roleRef))

  /** Returns a new data with subjects set to new value */
  def withSubjects(value: Seq[io.k8s.api.rbac.v1.Subject]) : RoleBinding = copy(subjects = Some(value))
  /** Appends new values to subjects */
  def addSubjects(newValues: io.k8s.api.rbac.v1.Subject*) : RoleBinding = copy(subjects = Some(subjects.fold(newValues)(_ ++ newValues)))
  /** if subjects has a value, transforms to the result of function*/
  def mapSubjects(f: Seq[io.k8s.api.rbac.v1.Subject] => Seq[io.k8s.api.rbac.v1.Subject]) : RoleBinding = copy(subjects = subjects.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : RoleBinding = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : RoleBinding = copy(metadata = metadata.map(f))
}

