package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** RoleList is a collection of Roles */
final case class RoleList(
  items : Seq[io.k8s.api.rbac.v1.Role],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "RoleList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.rbac.v1.Role]) : RoleList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.rbac.v1.Role*) : RoleList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.rbac.v1.Role] => Seq[io.k8s.api.rbac.v1.Role]) : RoleList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : RoleList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : RoleList = copy(metadata = metadata.map(f))
}

