package io.k8s.api.storage.v1


/** CSINodeSpec holds information about the specification of all CSI drivers installed on a node */
final case class CSINodeSpec(
  drivers : Seq[io.k8s.api.storage.v1.CSINodeDriver]
) {

  /** Returns a new data with drivers set to new value */
  def withDrivers(value: Seq[io.k8s.api.storage.v1.CSINodeDriver]) : CSINodeSpec = copy(drivers = value)
  /** Appends new values to drivers */
  def addDrivers(newValues: io.k8s.api.storage.v1.CSINodeDriver*) : CSINodeSpec = copy(drivers = drivers ++ newValues)
  /** transforms drivers to result of function */
  def mapDrivers(f: Seq[io.k8s.api.storage.v1.CSINodeDriver] => Seq[io.k8s.api.storage.v1.CSINodeDriver]) : CSINodeSpec = copy(drivers = f(drivers))
}

