package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** StorageClassList is a collection of storage classes. */
final case class StorageClassList(
  items : Seq[io.k8s.api.storage.v1.StorageClass],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "StorageClassList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.storage.v1.StorageClass]) : StorageClassList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.storage.v1.StorageClass*) : StorageClassList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.storage.v1.StorageClass] => Seq[io.k8s.api.storage.v1.StorageClass]) : StorageClassList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageClassList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageClassList = copy(metadata = metadata.map(f))
}

