package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttachment objects are non-namespaced. */
final case class VolumeAttachment(
  spec : io.k8s.api.storage.v1.VolumeAttachmentSpec,
  status : Option[io.k8s.api.storage.v1.VolumeAttachmentStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "VolumeAttachment", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.storage.v1.VolumeAttachmentSpec) : VolumeAttachment = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.storage.v1.VolumeAttachmentSpec => io.k8s.api.storage.v1.VolumeAttachmentSpec) : VolumeAttachment = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.storage.v1.VolumeAttachmentStatus) : VolumeAttachment = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.storage.v1.VolumeAttachmentStatus => io.k8s.api.storage.v1.VolumeAttachmentStatus) : VolumeAttachment = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : VolumeAttachment = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : VolumeAttachment = copy(metadata = metadata.map(f))
}

