package io.k8s.api.storage.v1


/** VolumeAttachmentStatus is the status of a VolumeAttachment request. */
final case class VolumeAttachmentStatus(
  attached : Boolean,
  attachError : Option[io.k8s.api.storage.v1.VolumeError] = None,
  attachmentMetadata : Option[Map[String, String]] = None,
  detachError : Option[io.k8s.api.storage.v1.VolumeError] = None
) {

  /** Returns a new data with attached set to new value */
  def withAttached(value: Boolean) : VolumeAttachmentStatus = copy(attached = value)
  /** transforms attached to result of function */
  def mapAttached(f: Boolean => Boolean) : VolumeAttachmentStatus = copy(attached = f(attached))

  /** Returns a new data with attachError set to new value */
  def withAttachError(value: io.k8s.api.storage.v1.VolumeError) : VolumeAttachmentStatus = copy(attachError = Some(value))
  /** if attachError has a value, transforms to the result of function*/
  def mapAttachError(f: io.k8s.api.storage.v1.VolumeError => io.k8s.api.storage.v1.VolumeError) : VolumeAttachmentStatus = copy(attachError = attachError.map(f))

  /** Returns a new data with attachmentMetadata set to new value */
  def withAttachmentMetadata(value: Map[String, String]) : VolumeAttachmentStatus = copy(attachmentMetadata = Some(value))
  /** Adds new values to attachmentMetadata */
  def addAttachmentMetadata(newValues: (String, String)*) : VolumeAttachmentStatus = copy(attachmentMetadata = Some(attachmentMetadata.fold(newValues.toMap)(_ ++ newValues)))
  /** if attachmentMetadata has a value, transforms to the result of function*/
  def mapAttachmentMetadata(f: Map[String, String] => Map[String, String]) : VolumeAttachmentStatus = copy(attachmentMetadata = attachmentMetadata.map(f))

  /** Returns a new data with detachError set to new value */
  def withDetachError(value: io.k8s.api.storage.v1.VolumeError) : VolumeAttachmentStatus = copy(detachError = Some(value))
  /** if detachError has a value, transforms to the result of function*/
  def mapDetachError(f: io.k8s.api.storage.v1.VolumeError => io.k8s.api.storage.v1.VolumeError) : VolumeAttachmentStatus = copy(detachError = detachError.map(f))
}

