package io.k8s.api.storage.v1


/** VolumeNodeResources is a set of resource limits for scheduling of volumes. */
final case class VolumeNodeResources(
  count : Option[Int] = None
) {

  /** Returns a new data with count set to new value */
  def withCount(value: Int) : VolumeNodeResources = copy(count = Some(value))
  /** if count has a value, transforms to the result of function*/
  def mapCount(f: Int => Int) : VolumeNodeResources = copy(count = count.map(f))
}

