package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceColumnDefinition specifies a column for server side printing. */
final case class CustomResourceColumnDefinition(
  name : String,
  jsonPath : String,
  `type` : String,
  format : Option[String] = None,
  priority : Option[Int] = None,
  description : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : CustomResourceColumnDefinition = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : CustomResourceColumnDefinition = copy(name = f(name))

  /** Returns a new data with jsonPath set to new value */
  def withJsonPath(value: String) : CustomResourceColumnDefinition = copy(jsonPath = value)
  /** transforms jsonPath to result of function */
  def mapJsonPath(f: String => String) : CustomResourceColumnDefinition = copy(jsonPath = f(jsonPath))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : CustomResourceColumnDefinition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : CustomResourceColumnDefinition = copy(`type` = f(`type`))

  /** Returns a new data with format set to new value */
  def withFormat(value: String) : CustomResourceColumnDefinition = copy(format = Some(value))
  /** if format has a value, transforms to the result of function*/
  def mapFormat(f: String => String) : CustomResourceColumnDefinition = copy(format = format.map(f))

  /** Returns a new data with priority set to new value */
  def withPriority(value: Int) : CustomResourceColumnDefinition = copy(priority = Some(value))
  /** if priority has a value, transforms to the result of function*/
  def mapPriority(f: Int => Int) : CustomResourceColumnDefinition = copy(priority = priority.map(f))

  /** Returns a new data with description set to new value */
  def withDescription(value: String) : CustomResourceColumnDefinition = copy(description = Some(value))
  /** if description has a value, transforms to the result of function*/
  def mapDescription(f: String => String) : CustomResourceColumnDefinition = copy(description = description.map(f))
}

