package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceDefinitionVersion describes a version for CRD. */
final case class CustomResourceDefinitionVersion(
  name : String,
  served : Boolean,
  storage : Boolean,
  deprecationWarning : Option[String] = None,
  deprecated : Option[Boolean] = None,
  subresources : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] = None,
  schema : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation] = None,
  additionalPrinterColumns : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : CustomResourceDefinitionVersion = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : CustomResourceDefinitionVersion = copy(name = f(name))

  /** Returns a new data with served set to new value */
  def withServed(value: Boolean) : CustomResourceDefinitionVersion = copy(served = value)
  /** transforms served to result of function */
  def mapServed(f: Boolean => Boolean) : CustomResourceDefinitionVersion = copy(served = f(served))

  /** Returns a new data with storage set to new value */
  def withStorage(value: Boolean) : CustomResourceDefinitionVersion = copy(storage = value)
  /** transforms storage to result of function */
  def mapStorage(f: Boolean => Boolean) : CustomResourceDefinitionVersion = copy(storage = f(storage))

  /** Returns a new data with deprecationWarning set to new value */
  def withDeprecationWarning(value: String) : CustomResourceDefinitionVersion = copy(deprecationWarning = Some(value))
  /** if deprecationWarning has a value, transforms to the result of function*/
  def mapDeprecationWarning(f: String => String) : CustomResourceDefinitionVersion = copy(deprecationWarning = deprecationWarning.map(f))

  /** Returns a new data with deprecated set to new value */
  def withDeprecated(value: Boolean) : CustomResourceDefinitionVersion = copy(deprecated = Some(value))
  /** if deprecated has a value, transforms to the result of function*/
  def mapDeprecated(f: Boolean => Boolean) : CustomResourceDefinitionVersion = copy(deprecated = deprecated.map(f))

  /** Returns a new data with subresources set to new value */
  def withSubresources(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources) : CustomResourceDefinitionVersion = copy(subresources = Some(value))
  /** if subresources has a value, transforms to the result of function*/
  def mapSubresources(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources) : CustomResourceDefinitionVersion = copy(subresources = subresources.map(f))

  /** Returns a new data with schema set to new value */
  def withSchema(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation) : CustomResourceDefinitionVersion = copy(schema = Some(value))
  /** if schema has a value, transforms to the result of function*/
  def mapSchema(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation) : CustomResourceDefinitionVersion = copy(schema = schema.map(f))

  /** Returns a new data with additionalPrinterColumns set to new value */
  def withAdditionalPrinterColumns(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]) : CustomResourceDefinitionVersion = copy(additionalPrinterColumns = Some(value))
  /** Appends new values to additionalPrinterColumns */
  def addAdditionalPrinterColumns(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition*) : CustomResourceDefinitionVersion = copy(additionalPrinterColumns = Some(additionalPrinterColumns.fold(newValues)(_ ++ newValues)))
  /** if additionalPrinterColumns has a value, transforms to the result of function*/
  def mapAdditionalPrinterColumns(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]) : CustomResourceDefinitionVersion = copy(additionalPrinterColumns = additionalPrinterColumns.map(f))
}

