package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources. */
final case class CustomResourceSubresourceScale(
  specReplicasPath : String,
  statusReplicasPath : String,
  labelSelectorPath : Option[String] = None
) {

  /** Returns a new data with specReplicasPath set to new value */
  def withSpecReplicasPath(value: String) : CustomResourceSubresourceScale = copy(specReplicasPath = value)
  /** transforms specReplicasPath to result of function */
  def mapSpecReplicasPath(f: String => String) : CustomResourceSubresourceScale = copy(specReplicasPath = f(specReplicasPath))

  /** Returns a new data with statusReplicasPath set to new value */
  def withStatusReplicasPath(value: String) : CustomResourceSubresourceScale = copy(statusReplicasPath = value)
  /** transforms statusReplicasPath to result of function */
  def mapStatusReplicasPath(f: String => String) : CustomResourceSubresourceScale = copy(statusReplicasPath = f(statusReplicasPath))

  /** Returns a new data with labelSelectorPath set to new value */
  def withLabelSelectorPath(value: String) : CustomResourceSubresourceScale = copy(labelSelectorPath = Some(value))
  /** if labelSelectorPath has a value, transforms to the result of function*/
  def mapLabelSelectorPath(f: String => String) : CustomResourceSubresourceScale = copy(labelSelectorPath = labelSelectorPath.map(f))
}

