package io.k8s.apimachinery.pkg.apis.meta.v1


/** A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values. */
final case class LabelSelectorRequirement(
  key : String,
  operator : String,
  values : Option[Seq[String]] = None
) {

  /** Returns a new data with key set to new value */
  def withKey(value: String) : LabelSelectorRequirement = copy(key = value)
  /** transforms key to result of function */
  def mapKey(f: String => String) : LabelSelectorRequirement = copy(key = f(key))

  /** Returns a new data with operator set to new value */
  def withOperator(value: String) : LabelSelectorRequirement = copy(operator = value)
  /** transforms operator to result of function */
  def mapOperator(f: String => String) : LabelSelectorRequirement = copy(operator = f(operator))

  /** Returns a new data with values set to new value */
  def withValues(value: Seq[String]) : LabelSelectorRequirement = copy(values = Some(value))
  /** Appends new values to values */
  def addValues(newValues: String*) : LabelSelectorRequirement = copy(values = Some(values.fold(newValues)(_ ++ newValues)))
  /** if values has a value, transforms to the result of function*/
  def mapValues(f: Seq[String] => Seq[String]) : LabelSelectorRequirement = copy(values = values.map(f))
}

