package io.k8s.apimachinery.pkg.apis.meta.v1


/** ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to. */
final case class ManagedFieldsEntry(
  operation : Option[String] = None,
  manager : Option[String] = None,
  fieldsV1 : Option[io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1] = None,
  time : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  fieldsType : Option[String] = None,
  subresource : Option[String] = None
) {

  /** Returns a new data with operation set to new value */
  def withOperation(value: String) : ManagedFieldsEntry = copy(operation = Some(value))
  /** if operation has a value, transforms to the result of function*/
  def mapOperation(f: String => String) : ManagedFieldsEntry = copy(operation = operation.map(f))

  /** Returns a new data with manager set to new value */
  def withManager(value: String) : ManagedFieldsEntry = copy(manager = Some(value))
  /** if manager has a value, transforms to the result of function*/
  def mapManager(f: String => String) : ManagedFieldsEntry = copy(manager = manager.map(f))

  /** Returns a new data with fieldsV1 set to new value */
  def withFieldsV1(value: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1) : ManagedFieldsEntry = copy(fieldsV1 = Some(value))
  /** if fieldsV1 has a value, transforms to the result of function*/
  def mapFieldsV1(f: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1 => io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1) : ManagedFieldsEntry = copy(fieldsV1 = fieldsV1.map(f))

  /** Returns a new data with time set to new value */
  def withTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ManagedFieldsEntry = copy(time = Some(value))
  /** if time has a value, transforms to the result of function*/
  def mapTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ManagedFieldsEntry = copy(time = time.map(f))

  /** Returns a new data with fieldsType set to new value */
  def withFieldsType(value: String) : ManagedFieldsEntry = copy(fieldsType = Some(value))
  /** if fieldsType has a value, transforms to the result of function*/
  def mapFieldsType(f: String => String) : ManagedFieldsEntry = copy(fieldsType = fieldsType.map(f))

  /** Returns a new data with subresource set to new value */
  def withSubresource(value: String) : ManagedFieldsEntry = copy(subresource = Some(value))
  /** if subresource has a value, transforms to the result of function*/
  def mapSubresource(f: String => String) : ManagedFieldsEntry = copy(subresource = subresource.map(f))
}

